#include <stdio.h>
#include <string.h>

#define MAXCHAINE 50
#define MAXGROUPE 10
#define MAXFICHE 50

typedef struct date{
  int jour;
  int mois;
  int annee;
}Date;

typedef struct fiche{
  char nom[MAXCHAINE];
  char prenom[MAXCHAINE];
  char genre;
  Date naissance;
  int groupe[MAXGROUPE];
}Fiche;

typedef struct repertoire{
  Fiche pers[MAXFICHE];
  int taille;
}Repertoire;


void affiche_date(Date *d){
  printf("Né(e) le %d/%d/%d\n", (*d).jour, (*d).mois, (*d).annee);
}

void saisir_date(Date *d){
  int j,m,a;

  printf("Veuillez entrée une Date (au format xx/xx/xxxx) :\n");
  scanf("%d/%d/%d", &j, &m, &a);

  if ((j >= 32) || (j <= 0))
    {
      printf("Jour incorrect!!\n");
      return saisir_date(d);
    }

  if ((m >= 13) || (m <= 0))
    {
      printf("Mois incorrect!!\n");
      return saisir_date(d);
    }

  if ((a >= 2014) || (a <= 0))
    {
      printf("Annee incorrecte!!\n");
      return saisir_date(d);
    }

  (*d).jour = j;
  (*d).mois = m;
  (*d).annee = a;
}

int meme_mois(Date *un, Date *deux){
  
  if ((*un).mois == (*deux).mois)
    return 1;
  return 0;
}

void affiche_fiche(Fiche *f){
  int i;

  printf("  - - - - - - - - - - - - - - - - - - - -\n");
  printf("%s %s (%c)\n", (*f).nom, (*f).prenom, (*f).genre);
  affiche_date(&((*f).naissance));
  printf("Fait parti des groupes numéros :\n");
  for (i=0 ; i<MAXGROUPE ; i++)
    printf("%d ", ((*f).groupe)[i]);
  printf("\n");
  printf("  - - - - - - - - - - - - - - - - - - - -\n");
}

void saisir_fiche(Fiche *f){
  int i;
  
  printf("Saisie d'une nouvelle fiche :\n");
  printf("Veuillez entrer un nom prénom et genre de la personne :\n");
  printf("(chaque élément séparé par un espace) (h pour homme, f pour femme)\n");
  scanf("%s %s %c", (*f).nom, (*f).prenom, &((*f).genre));
  saisir_date(&((*f).naissance));
  printf("Veuillez entrer un liste de MAXGROUPE entiers :\n");
  printf("(0 si la personne n'est pas dans le groupe et 1 si elle y appartient) :\n");
  for (i=0 ; i < MAXGROUPE ; i++)
    scanf("%d", &((*f).groupe[i]));
}

int nombre_groupe(Fiche *f){
  int i, j;

  j = 0;
  for (i=0 ; i < MAXGROUPE ; i++)
    {
      if ((*f).groupe[i] == 1)
	j++;
    }

  return j;
}

void affiche_repertoire(Repertoire *R){
  int i;

  printf("**************** REPERTOIRE ****************\n");

  for (i=0 ; i<(*R).taille ; i++)
    affiche_fiche(&((*R).pers[i]));
}

void sauve_repertoire(Repertoire *R){
  FILE *fich_rep;
  int i, j;
  
  fich_rep = fopen("data/repertoire.txt", "w");
  if (fich_rep == NULL)
    {
      printf("Problème d'ouverture de fichier en écriture.\n");
      return ;
    }

  for (i=0 ; i<(*R).taille ; i++)
    {
      fprintf(fich_rep, "%s %s (%c) ", ((*R).pers[i]).nom, ((*R).pers[i]).prenom, ((*R).pers[i]).genre);
      fprintf(fich_rep, "%d/%d/%d ", ((*R).pers[i]).naissance.jour, ((*R).pers[i]).naissance.mois, ((*R).pers[i]).naissance.annee);
      for (j=0 ; j<MAXGROUPE ; j++)
	fprintf(fich_rep, "%d ", ((*R).pers[i]).groupe[j]);
      fprintf(fich_rep, "\n");
    }

  fclose(fich_rep);
}

void charge_repertoire(Repertoire *R){
  FILE *fich_rep;
  Fiche f;
  int i;

  fich_rep = fopen("data/repertoire.txt", "r");
  if (fich_rep == NULL)
    {
      printf("Problème d'ouverture de fichier en lecture.\n");
      return ;
    }
  
  while (fscanf(fich_rep, "%s %s (%c)", f.nom, f.prenom, &(f.genre)) == 3)
    {
      fscanf(fich_rep, "%d/%d/%d", &(f.naissance.jour), &(f.naissance.mois), &(f.naissance.annee));
      for (i=0 ; i<MAXGROUPE ; i++)
	fscanf(fich_rep, "%d", &(f.groupe[i]));

      ajoute_fiche(R, &f);
    }

  fclose(fich_rep);  

}

int ajoute_fiche(Repertoire *R, Fiche *f){
  int pos, i;

  if ((*R).taille >= MAXFICHE) 
    {
      fprintf(stderr, "Ajout impossible, répertoire plein!\n");
      return 1;
    }

  pos = (*R).taille;
  (*R).taille++;
  strcpy((*R).pers[pos].nom, (*f).nom);
  strcpy((*R).pers[pos].prenom, (*f).prenom);
  (*R).pers[pos].genre = (*f).genre;

  (*R).pers[pos].naissance.jour = (*f).naissance.jour;  
  (*R).pers[pos].naissance.mois = (*f).naissance.mois;
  (*R).pers[pos].naissance.annee = (*f).naissance.annee;
  
  for (i=0 ; i<MAXGROUPE ; i++)
    {
      (*R).pers[pos].groupe[i] = (*f).groupe[i];
    }

  printf("Nouvelle entrée dans le repertoire : fiche numero %d\n", pos);
  return 0;
}

int main(void){
  Repertoire R;

  /* Initialisation repertoire */
  R.taille=0;

  charge_repertoire(&R);

  affiche_repertoire(&R);

  return 0;
}
