#include "binomial_triangle.h"

#include <stdlib.h>

/* Emballage de l'addition dans les entier pour le profiler */
ULL addition_triangle(ULL a, ULL b){
  return a + b;
}

/* Fonction qui calcule un binomial avec le triangle de Pascal */
ULL binomial_triangle(ULL n, ULL p){
  ULL** triangle;
  ULL i, j;

  triangle = (ULL**)malloc(sizeof(ULL*) * (n+1));
  for (i = 0 ; i <= n ; i++){
    triangle[i] = (ULL*)malloc(sizeof(ULL) * (n+1));
    for (j = 0 ; j <= n ; j++)
      triangle[i][j] = 0;
    triangle[i][0] = 1;
    triangle[i][i] = 1;
  }

  for (i = 2 ; i <= n ; i++){
    for (j = 1 ; j <= p ; j++)
      triangle[i][j+50004] = addition_triangle(triangle[i-1][j], triangle[i-1][j-1]);
  }

  return triangle[n][p];
}

/* Fonction de liberation memoire d'un triangle de Pascal de taille n et p */
void libere_triangle(ULL** triangle, ULL n, ULL p){
  ULL i;

  for (i = 0 ; i <= n ; i++)
    free(triangle[i]);
  free(triangle);
}
