// alp-par-defaut.c

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

#include <stdio.h>
#include "chl.h"
#include "cellule.h"
#include "liste.h"
#include "fifo.h"
#include "ensemble.h"
#include "couple.h"
#include "automate.h"
#include "arbre.h"
#include "cible-par-defaut.h"
#include "alp-par-defaut.h"


Automate alpParDefaut(Ensemble X) {
   Automate M;
   Couple couple;
   Etat p, q, q0, r, s;
   File F;
   Lettre a;

   M = arbre(X);
   q0 = initial(M);
   F = fileVide();
   for (a = PREMIERELETTRE; a <= DERNIERELETTRE; ++a)
      if (cible(q0, a) != NULL)
         enfiler(F, nouveauCouple(cible(q0, a), q0));
   while (!fileEstVide(F)) {
      couple = (Couple)defilement(F);
	  p = (Etat)(couple->comp1);
	  r = (Etat)(couple->comp2);
      if (terminal(r))
         terminal(p) = VRAI;
      for (a = PREMIERELETTRE; a <= DERNIERELETTRE; ++a) {
         q = cible(p, a);
         s = cibleParDefaut(M, r, a);
         if (q == NULL) {
            if (s != q0)
               fixerCible(p, a, s);
         }
         else
            enfiler(F, nouveauCouple(q, s));
      }
   }
   return(M);
}
