// alp-par-suppleance.c

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

#include <stdio.h>
#include "chl.h"
#include "cellule.h"
#include "liste.h"
#include "ensemble.h"
#include "fifo.h"
#include "automate.h"
#include "arbre.h"
#include "cible-par-suppleance.h"

Automate alpParSuppleance(Ensemble X) {
   Automate M;
   Etat p, r, t;
   File F;
   Lettre a;

   M = arbre(X);
   suppleant(initial(M)) = NULL;
   F = fileVide();
   enfiler(F, initial(M));
   while (!fileEstVide(F)) {
      t = (Etat)defilement(F);
      for (a = PREMIERELETTRE; a <= DERNIERELETTRE; ++a)
         if (cible(t, a) != NULL) {
            p = cible(t, a);
            r = cibleParSuppleance(M, suppleant(t), a);
            suppleant(p) = r;
            if (terminal(r))
               terminal(p) = VRAI;
            enfiler(F, p);
         }
   }
   return(M);
}
