// alu-complet.c

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

#include <stdio.h>
#include "chl.h"
#include "automate.h"

Automate aluComplet(Mot x) {
   Automate M;
   Etat p, q0, r, t;
   Lettre b;

   M = nouvelAutomate();
   q0 = initial(M);
   for (b = PREMIERELETTRE; b <= DERNIERELETTRE; ++b)
      fixerCible(q0, b, q0);
   t = q0;
   for (; *x != '\0'; ++x) {
      p = nouvelEtat();
      r = cible(t, *x);
      fixerCible(t, *x, p);
      copieCibles(p, r);
      t = p;
   }
   terminal(t) = VRAI;
   return(M);
}
