// alu-par-defaut.c

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

#include <stdio.h>
#include "chl.h"
#include "automate.h"

Automate aluParDefaut(Mot x) {
   Automate M;
   Etat p, q0, r, t;

   M = nouvelAutomate();
   q0 = initial(M);
   t = q0;
   for (; *x != '\0'; ++x) {
      p = nouvelEtat();
      r = cible(t, *x);
	  if (r == NULL)
         r = q0;
      fixerCible(t, *x, p);
      copieCibles(p, r);
      t = p;
   }
   terminal(t) = VRAI;
   return(M);
}
