// arbre.c

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

#include <stdio.h>
#include "chl.h"
#include "automate.h"
#include "cellule.h"
#include "liste.h"
#include "ensemble.h"


Automate arbre(Ensemble X) {
   Automate M;
   Etat p, t;
   Mot x;

   M = nouvelAutomate();
   lister(X);
   while (!fin(X)) {
      t = initial(M);
      for (x = (Mot)suivant(X); *x != '\0'; ++x) {
         p = cible(t, *x);
         if (p == NULL) {
            p = nouvelEtat();
            fixerCible(t, *x, p);
         }
         t = p;
      }
      terminal(t) = VRAI;
   }
   return(M);
}
