// auto-align-opt.c

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

#include <stdio.h>
#include "chl.h"
#include "automate-align.h"
#include "aa.h"

#define E(i,j)   e[((i) + 1)*(n + 1) + (j) +1]
#define T(i,j)   t[((i) + 1)*(n + 1) + (j) +1]


Automate autoAlignOpt(Mot x, Longueur m, Mot y, Longueur n, int *t) {
   Automate M;
   Etat *e;

   e = (Etat *)calloc((m + 2)*(n + 2)*sizeof(Etat));
   if (e == NULL) error("autoAlignOpt");

   M = nouvelAutomate();
   E(-1, -1) = initial(M);
   E(m - 1, n - 1) = nouvelEtat();
   terminal(E(m - 1, n - 1)) = VRAI;
   aa(m - 1, n - 1, e, t, x, y, n);
   return(M);
}

