// automate-align.c

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

#include <stdio.h>
#include "chl.h"
#include "automate-align.h"

static int compteur = 0;
int *visite;

Etat nouvelEtat() {
   Etat etat;

   etat = (Etat)malloc(sizeof(struct _etat));
   if (etat == NULL) error("nouvelEtat");
   etat->terminal = FAUX;
   etat->succ = NULL;
   etat->nom = compteur++;
   return(etat);
}


void fixerCible(Etat etat, PaireAlignee a, Etat cible) {
   Succ succ;

   succ = (Succ)malloc(sizeof(struct _succ));
   if (succ == NULL) error("fixerCible");

   succ->etiq = a;
   succ->cible = cible;
   succ->suivant = etat->succ;
   etat->succ = succ;
}


Etat cible(Etat etat, PaireAlignee a) {
   Succ succ;

   succ = etat->succ;
   while (succ != NULL) {
      if (succ->etiq.haut == a.haut && succ->etiq.bas == a.bas) return(succ->cible);
	  else succ = succ->suivant;
   }
   return(NULL);
}


Automate nouvelAutomate() {
   Automate automate;

   automate = (Automate)malloc(sizeof(struct _automate));
   if (automate == NULL) error("nouvelAutomate");
   automate->initial = nouvelEtat();
   return(automate);
}


void ecrireEtat(Etat etat) {
   Succ succ;

   if (!visite[etat->nom]) {
      visite[etat->nom] = VRAI;
      printf("tat %d ", etat->nom);
      if (terminal(etat)) printf(" terminal");
      printf("\n");
	  succ = etat->succ;
	  while (succ != NULL) {
         printf("   delta(%d, (%c,%c)) = %d\n", etat->nom, succ->etiq.haut,
						                        succ->etiq.bas, succ->cible->nom);
         ecrireEtat(succ->cible);
		 succ = succ->suivant;
      }
   }
}


void ecrireAutomate(Automate automate) {
   visite = (int *)calloc(compteur, sizeof(int));
   if (visite == NULL) error("ecrireAutomate");
   ecrireEtat(initial(automate));
   free(visite);
}
