// automate-align.h

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

struct _paireAlignee {
   char haut, bas;
};

typedef struct _paireAlignee PaireAlignee;

struct _etat {
   int nom;
   char terminal;
   struct _succ *succ;
};

typedef struct _etat * Etat;

struct _succ {
   PaireAlignee etiq;
   Etat cible;
   struct _succ *suivant;
};

typedef struct _succ * Succ;

struct _automate {
   Etat initial;
};

typedef struct _automate * Automate;


#define initial(M) ((M)->initial)
#define terminal(q) ((q)->terminal)


Etat nouvelEtat();
void fixerCible(Etat etat, PaireAlignee a, Etat cible);
Etat cible(Etat etat, PaireAlignee a);
Automate nouvelAutomate();
void ecrireEtat(Etat etat);
void ecrireAutomate(Automate automate);
