// automate-suff.h

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

struct _etiquette {
   int position, longueur;
};

typedef struct _etiquette Etiquette;

struct _etat {
   int nom;
   int sortie;
   char terminal;
   struct _succ *succ;
   struct _etat *parent;
   struct _etat *suppleant;
};

typedef struct _etat * Etat;

struct _succ {
   Etiquette etiquette;
   Etat cible;
   struct _succ *suivant;
};

typedef struct _succ * Succ;

struct _automate {
   Etat initial;
};

typedef struct _automate * Automate;


#define initial(M) ((M)->initial)
#define ls(q) ((q)->suppleant)
#define parent(q) ((q)->parent)
#define sortie(q) ((q)->sortie)
#define terminal(q) ((q)->terminal)


Etat nouvelEtat();
void fixerCible(Etat etat, Etiquette a, Etat cible);
void oterCible(Etat etat, Etiquette a);
Etat cible(Etat etat, Etiquette a);
Etat cibleParUneLettre(Etat etat, Lettre a, Mot y);
Etiquette etiq(Etat p, Etat q);
Automate nouvelAutomate();
void ecrireEtat(Etat etat);
void ecrireAutomate(Automate automate);
