// automate.h

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

struct _etat {
   int nom;
   int indic;
   int sortie;
   int longueur;
   char terminal;
   struct _etat *cible;
   struct _etat *ls;
   struct _etat **succ;
   struct _etat *suppleant;
};

typedef struct _etat * Etat;

struct _automate {
   Etat dernier, initial;
};

typedef struct _automate * Automate;


#define FEUILLE -1
#define FOURCHE -2

#define dernier(M) ((M)->dernier)
#define initial(M) ((M)->initial)
#define ls(q) ((q)->ls)
#define sortie(q) ((q)->sortie)
#define suppleant(q) ((q)->suppleant)
#define F(q) ((q)->suppleant)
#define L(q) ((q)->longueur)
#define terminal(q) ((q)->terminal)


Etat nouvelEtat();
void fixerCible(Etat etat, Lettre a, Etat cible);
Etat cible(Etat etat, Lettre a);
void copieCibles(Etat p, Etat q);
Automate nouvelAutomate();
void ecrireEtat(Etat etat);
void ecrireAutomate(Automate automate);
