// cibles.c

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

#include <stdio.h>
#include "chl.h"
#include "cellule.h"
#include "liste.h"
#include "ensemble.h"
#include "couple.h"
#include "afn.h"


Ensemble cibles(Ensemble R, Lettre a) {
   Ensemble S;
   Etat p;
   Couple couple;

   S = listeVide();
   lister(R);
   while (!fin(R)) {
      p = (Etat)suivant(R);
      lister(p->succ);
      while (!fin(p->succ)) {
         couple = (Couple)suivant(p->succ);
         if (*(Lettre *)(couple->comp1) == a)
            inserer(S, couple->comp2);
      }
   }
   return(S);
}
