// def-lpc.c

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

#include <stdio.h>
#include "chl.h"
#include "llpc.h"


extern Mot *L;
extern int *LPC;
extern int n;


int defLPC(int d, int f) {
   int i;
   // On a d < f
   if (d + 1 == f) {
      if (d == -1 || f == n)
         LPC[f] = 0;
      else
         LPC[f] = llpc(L[d], L[f]);
      return(LPC[f]);
   }
   else {
      i = (d + f)/2;
      LPC[n + 1 + i] = MIN(defLPC(d, i), defLPC(i, f));
      return(LPC[n + 1 + i]);
   }
}
