// fifo.c

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

#include <stdio.h>
#include "cellule.h"
#include "fifo.h"


File fileVide() {
   File F;

   F = (File)malloc(sizeof(struct _file));
   if (F == NULL) error("fileVide");
   F->longueur = 0;
   F->tete = F->queue = NULL;
   return(F);
}


int longueur(File F) {
   if (F == NULL) error("longueur");
   return(F->longueur);
}


void enfiler(File F, void *element) {
   Cellule cellule;

   if (F == NULL) error("enfiler");
   cellule = (Cellule)malloc(sizeof(struct _cellule));
   if (cellule == NULL) error("enfiler");
   cellule->element = element;
   cellule->suivant = NULL;
   if (longueur(F) == 0)
      F->tete = F->queue = cellule;
   else {
      F->queue->suivant = cellule;
      F->queue = cellule;
   }
   ++(F->longueur);
}


void *tete(File F) {
   if (F == NULL || longueur(F) == 0) error("tete");
   return(F->tete->element);
}


void defiler(File F) {
   Cellule cellule;

   if (F == NULL || longueur(F) == 0) error("defiler");
   cellule = F->tete;
   if (longueur(F) == 1)
      F->tete = F->queue = NULL;
   else
      F->tete = F->tete->suivant;
   --(F->longueur);
   free(cellule);
}


void *defilement(File F) {
   Cellule cellule;
   void *element;

   if (F == NULL || longueur(F) == 0) error("defilement");
   cellule = F->tete;
   element = cellule->element;
   if (longueur(F) == 1)
      F->tete = F->queue = NULL;
   else
      F->tete = F->tete->suivant;
   free(cellule);
   --(F->longueur);
   return(element);
}


File copie(File F) {
   File G, H;
   Cellule cellule;

   if (F == NULL) error("copie");
   H = fileVide();
   cellule = F->tete;
   while (cellule != NULL) {
      enfiler(H, cellule->element);
      cellule = cellule->suivant;
   }
   G = fileVide();
   cellule = H->tete;
   while (cellule != NULL) {
      enfiler(G, cellule->element);
      cellule = cellule->suivant;
   }
   return(G);
}


void ecrireFile(File F) {
   Cellule cellule;

   if (F == NULL) error("ecrireFile");
   cellule = F->tete;
   while (cellule != NULL) {
      printf("%d ", *(int *)cellule->element);
      cellule = cellule->suivant;
   }
   printf("\n");
}
