// ineg-fusion.c

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

#include <stdio.h>
#include "chl.h"
#include "cellule.h"
#include "fifo.h"


File inegFusion(Mot x, Mot y, int f, int j, int g, int k, File Fin, File Gin) {
   File F, G, J;
   int p, q;

   F = copie(Fin);
   G = copie(Gin);
   J = fileVide();
   while (longueur(J) <= k && longueur(F) > 0 && longueur(G) > 0) {
      p = *(int *)tete(F);
      q = *(int *)tete(G);
      if (p < q) {
         defiler(F);
         enfiler(J, nouvelEntier(p - j + f));
      }
      else if (q < p) {
         defiler(G);
         enfiler(J, nouvelEntier(q - j + f));
      }
      else {
         defiler(F);
         defiler(G);
         if (x[p - j + f] != y[f + p])
            enfiler(J, nouvelEntier(p - j + f));
      }
   }
   while (longueur(J) <= k && longueur(F) > 0) {
      p = *(int *)defilement(F);
      enfiler(J, nouvelEntier(p - j + f));
   }
   while (longueur(J) <= k && longueur(G) > 0 && *(int *)tete(G) <= g - f) {
      q = *(int *)defilement(G);
      enfiler(J, nouvelEntier(q - j + f));
   }
   return(J);
}
