// l-diff-motif-court.c

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

#include <stdio.h>
#include "chl.h"


void lDiffMotifCourt(Mot x, Longueur m, Mot y, Longueur n, int k) {
   unsigned int i, j, *R, S[CARDA], T, Tp, masq;
   Lettre a;

   R = (int *)malloc((k + 1)*sizeof(int));
   if (R == NULL) error("lInegMotifCourt");

   for (a = PREMIERELETTRE; a <= DERNIERELETTRE; ++a)
      S[a] = ~0;
   for (i = 0, masq = 1; i <= m - 1; ++i, masq <<= 1)
      S[x[i]] &= ~masq;
   masq >>= 1;
   R[0] = ~0;
   for (i = 1; i <= k; ++i)
      R[i] = R[i - 1] << 1;
   for (j = 0; j <= n - 1; ++j) {
      T = R[0];
      R[0] = (R[0] << 1) | S[y[j]];
      for (i = 1; i <= k; ++i) {
         Tp = R[i];
         R[i] = ((R[i] << 1) | S[y[j]]) & ((T & R[i - 1]) << 1) & T;
         T = Tp;
      }
      signalerSi((R[k] & masq) == 0);
   }
}
