// l-inegalites.c

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

#include <stdio.h>
#include "chl.h"
#include "cellule.h"
#include "fifo.h"
#include "allouer.h"
#include "ineg-fusion.h"


void lInegalites(Mot x, Longueur m, Mot y, Longueur n, int k, File G[]) {
   File F, J;
   int f, g, j;

   F = fileVide();
   f = g = -1;
   for (j = 0; j <= n - m; ++j) {
      if (longueur(F) > 0 && *(int *)tete(F) == j - f - 1)
         defiler(F);
      if (j <= g)
         J = inegFusion(x, y, f, j, g, k, F, G[j - f]);
      else
         J = fileVide();
      if (longueur(J) <= k) {
         F = J;
         f = j;
         do {
            ++g;
            if (x[g - j] != y[g])
               enfiler(F, nouvelEntier(g - j));
         }
         while (longueur(F) <= k && g < j + m - 1);
         signalerSi(longueur(F) <= k);
      }
   }
}
