// la-deterministe-par-suppleance.c

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

#include <stdio.h>
#include "chl.h"
#include "cellule.h"
#include "liste.h"
#include "ensemble.h"
#include "automate.h"
#include "cible-par-suppleance.h"
#include "alp-par-suppleance.h"


void laDeterministeParSuppleance(Ensemble X, Mot y) {
   Automate M;
   Etat r;
   int j;

   M = alpParSuppleance(X);
   r = initial(M);
   for (j = 0; *y != '\0'; ++j, ++y) {
      r = cibleParSuppleance(M, r, *y);
      signalerSi(terminal(r));
   }
}
