// la-non-deterministe.c

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

#include <stdio.h>
#include "chl.h"
#include "cellule.h"
#include "liste.h"
#include "ensemble.h"
#include "cibles.h"
#include "afn.h"

void laNonDeterministe(Automate N, Mot y) {
   Etat p, q0;
   Ensemble R;
   int j;
   Booleen t;

   q0 = initial(N);
   R = listeVide();
   ajouter(R, q0);
   for (j = 0; *y != '\0'; ++j, ++y) {
      R = cibles(R, *y);
      ajouter(R, q0);
      t = FAUX;
      lister(R);
      while (!fin(R)) {
         p = (Etat)suivant(R);
         if (terminal(p))
            t = VRAI;
      }
      signalerSi(t);
   }
}
