// liste.c

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

#include <stdio.h>
#include "chl.h"
#include "cellule.h"
#include "liste.h"

Liste listeVide() {
   Liste liste;

   liste = (Liste)malloc(sizeof(struct _liste));
   if (liste == NULL)
      error("listeVide");
   liste->debut = liste->parcours = NULL;
   return(liste);
}


Booleen estListeVide(Liste liste) {
   return(liste->debut == NULL);
}


void lister(Liste liste) {
   liste->parcours = liste->debut;
}


Booleen fin(Liste liste) {
   return(liste->parcours == NULL);
}


void *suivant(Liste liste) {
// liste->parcours != NULL
   void *resultat;

   resultat = liste->parcours->element;
   liste->parcours = liste->parcours->suivant;
   return(resultat);
}


void inserer(Liste liste, void *element) {
   Cellule cellule;

   cellule = (Cellule)malloc(sizeof(struct _cellule));
   if (cellule == NULL)
      error("inserer");
   cellule->element = element;
   cellule->suivant = liste->debut;
   liste->debut = cellule;
}
