// longueur-des-facteurs.c

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

#include <stdio.h>
#include "chl.h"
#include "automate.h"


void longueurDesFacteurs(Automate Sx, Mot y, Longueur n) {
   Etat p;
   int i, ell;

   ell = 0;
   p = initial(Sx);
   for (i = 0; i <= n - 1; ++i) {
      if (cible(p, y[i]) != NULL) {
         ++ell;
         p = cible(p, y[i]);
      }
      else {
         do {
            p = F(p);
         }
         while (p != NULL && cible(p, y[i]) == NULL);
         if (p != NULL) {
            ell = L(p) + 1;
            p = cible(p, y[i]);
         }
         else {
            ell = 0;
            p = initial(Sx);
         }
      }
      printf("%d\n", ell);
   }
}
