// ls-plusieurs-memoires-faible.c

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

#include <stdio.h>
#include "chl.h"


void lsPlusieursMemoiresFaible(Mot x, Longueur m, int suff[], int bonSuff[], Mot y, Longueur n) {
   int i, j, k, s, *S;

   S = (int *)malloc(n*sizeof(int));
   if (S == NULL) error("lsPlusieursMemoiresFaible");

   for (j = 0; j < n; ++j) S[j] = 0;   // memset(S, 0, n*sizeof(int));

   j = m - 1;
   while (j < n) {
      i = m - 1;
      while (i >= 0)
         if (S[j - m + 1 + i] > 0) {
            k = S[j - m + 1 + i];
            s = suff[i];
            if (s != k) {
               i -= MIN(s, k);
               break;
            }
            else
               i -= k;   // Saut
         }
         else if (x[i] == y[j - m + 1 + i])
            --i;
         else
            break;
      signalerSi(i < 0);
      if (i < 0) {
         S[j] = m;
         j += bonSuff[0];
      }
      else {
         S[j] = m - 1 - i;
         j += bonSuff[i];
      }
   }
}
