// petit-automate.c

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

#include <stdio.h>
#include "chl.h"
#include "cellule.h"
#include "liste.h"
#include "ensemble.h"


void petitAutomate(Ensemble X, int m,
                   int *resInit, int *resTerm, int masq[]) {
   int init, term;
   int p;
   Lettre a;
   Mot x;

   init = 0;
   term = 0;
   for (a = PREMIERELETTRE; a <= DERNIERELETTRE; ++a)
      masq[a] = 0;
   p = 1;
   lister(X);
   while (!fin(X)) {
      init |= p;
      for (x = (Mot)suivant(X); *x != '\0'; ++x) {
         masq[*x] |= p;
         p <<= 1;
      }
      term |= (p >> 1);
   }
   *resInit = init;
   *resTerm = term;
}
