// pre-l-inegalites.c

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

#include <stdio.h>
#include "chl.h"
#include "cellule.h"
#include "fifo.h"
#include "allouer.h"


File *preLInegalites(Mot x, Longueur m, int k) {
   File *G;
   int i, q;

   G = (File *)malloc(m*sizeof(File));
   if (G == NULL) error("preLInegalites");

   for (q = 1; q <= m - 1; ++q) {
      G[q] = fileVide();
      i = q;
	  while (longueur(G[q]) < 2*k + 1 && i < m ) {
         if (x[i] != x[i - q])
            enfiler(G[q], nouvelEntier(i));
         ++i;
      }
   }
   return(G);
}
