// sous-mot.c

// << Algorithmique du texte >>
// Maxime Crochemore, Christophe Hancart et Thierry Lecroq
// Vuibert, 2001.

#include <stdio.h>
#include "chl.h"
#include "sous-mot.h"


SousMot creerSousMot(Lettre a) {
   SousMot sm;

   sm = (SousMot)malloc(sizeof(struct _sousMot));
   if (sm == NULL) error("creerSousmot");
   sm->element = a;
   sm->suivant = NULL;
   return(sm);
}


SousMot ajouterAuDebutSousMot(SousMot z, Lettre a) {
   SousMot sm;

   sm = (SousMot)malloc(sizeof(struct _sousMot));
   if (sm == NULL) error("ajouterAuDebutSousmot");
   sm->element = a;
   sm->suivant = z;
   return(sm);
}


SousMot concatenerSousMot(SousMot u, SousMot v) {
   SousMot z;

   if (u == NULL)
      return(v);
   else {
      z = u;
      while (z->suivant != NULL)
         z = z->suivant;
      z->suivant = v;
      return(u);
   }
}


void ecrireSousMot(SousMot z) {
   while (z != NULL) {
      printf("%c", z->element);
	  z = z->suivant;
   }
   printf("\n");
}
